from flask import Flask, render_template, request, redirect, url_for
import smtplib
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from database import save_contact

app = Flask(__name__)

# Configuración del servidor de correo SMTP
SMTP_SERVER = 'smtp.gmail.com'
SMTP_PORT = 587
# Reemplaza con tus credenciales de Gmail o el servicio de correo que utilices
SMTP_USER = 'tu_correo@gmail.com'  
SMTP_PASSWORD = 'tu_contraseña_de_aplicacion' 

def send_email(subject, body, to_email):
    """Función para enviar un correo electrónico."""
    try:
        msg = MIMEMultipart()
        msg['From'] = SMTP_USER
        msg['To'] = to_email
        msg['Subject'] = subject
        msg.attach(MIMEText(body, 'plain'))

        with smtplib.SMTP(SMTP_SERVER, SMTP_PORT) as server:
            server.starttls()
            server.login(SMTP_USER, SMTP_PASSWORD)
            text = msg.as_string()
            server.sendmail(SMTP_USER, to_email, text)
        return True
    except Exception as e:
        print(f"Error al enviar correo: {e}")
        return False

@app.route('/')
def home():
    """Ruta principal para mostrar el formulario."""
    return render_template('contact_form.html')

@app.route('/submit', methods=['POST'])
def submit():
    """Ruta para procesar el formulario de contacto."""
    nombre = request.form['nombre']
    correo = request.form['correo_electronico']
    telefono = request.form['telefono']
    consulta = request.form['consulta']
    
    # Guardar los datos en la base de datos
    success_db = save_contact(nombre, correo, telefono, consulta)
    
    # Enviar correo al administrador
    body_admin = f"Nuevo contacto de: {nombre}\nCorreo: {correo}\nTeléfono: {telefono}\nConsulta: {consulta}"
    subject_admin = f"Nueva consulta de {nombre}"
    success_admin_email = send_email(subject_admin, body_admin, 'contacto@cevetcahuil.cl')
    
    # Enviar correo de confirmación al cliente
    body_client = f"Hola {nombre},\n\nGracias por contactarnos. Hemos recibido tu consulta y te responderemos a la brevedad.\n\nAtentamente,\nVeterinaria C-VET"
    subject_client = "Confirmación de recepción de tu consulta"
    success_client_email = send_email(subject_client, body_client, correo)
    
    # Redirigir a la página de éxito
    return redirect(url_for('success_page'))

@app.route('/success')
def success_page():
    """Ruta para mostrar la página de éxito."""
    return render_template('success.html')

if __name__ == '__main__':
    app.run(debug=True)
