import mysql.connector
from mysql.connector import Error

# Configuración de la base de datos MySQL (reemplaza con tus datos de XAMPP si son diferentes)
DB_HOST = 'localhost'
DB_USER = 'root'
DB_PASSWORD = ''  # Por lo general, la contraseña está vacía en una instalación predeterminada de XAMPP
DB_DATABASE = 'veterinaria'

def create_connection():
    """Crea una conexión a la base de datos MySQL."""
    connection = None
    try:
        connection = mysql.connector.connect(
            host=DB_HOST,
            user=DB_USER,
            password=DB_PASSWORD,
            database=DB_DATABASE
        )
        print("Conexión a MySQL exitosa")
        return connection
    except Error as e:
        print(f"El error '{e}' ocurrió al intentar la conexión")
        return None

def save_contact(nombre, correo, telefono, consulta):
    """
    Guarda los datos del contacto en la tabla 'contactos' de la base de datos.
    Si la tabla no existe, la crea automáticamente.
    """
    connection = create_connection()
    if connection is None:
        return False
    
    cursor = connection.cursor()
    
    # Crea la tabla si no existe
    create_table_query = """
    CREATE TABLE IF NOT EXISTS contactos (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nombre VARCHAR(255) NOT NULL,
        correo_electronico VARCHAR(255) NOT NULL,
        telefono VARCHAR(20),
        consulta TEXT,
        fecha_creacion TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );
    """
    try:
        cursor.execute(create_table_query)
        connection.commit()
    except Error as e:
        print(f"El error '{e}' ocurrió al crear la tabla")
        return False
    
    # Inserta los datos del formulario
    insert_query = """
    INSERT INTO contactos (nombre, correo_electronico, telefono, consulta) 
    VALUES (%s, %s, %s, %s);
    """
    try:
        cursor.execute(insert_query, (nombre, correo, telefono, consulta))
        connection.commit()
        print("Datos de contacto guardados exitosamente")
        return True
    except Error as e:
        print(f"El error '{e}' ocurrió al insertar los datos")
        return False
    finally:
        # Cierra el cursor y la conexión al finalizar
        cursor.close()
        connection.close()
